<?php
include '../../fpdf.php';
include "../../root.class.php";

$total_stock_value = 0.00;
$db = new db_safeguard();
$call = new call_functions();
$where_data = ' 1 ';
function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');
$jobcard_res = $db->query("job_cards", "SELECT * FROM job_cards WHERE record_id = {$_GET['record_id']}");
$jobcard = $jobcard_res->fetch_assoc();
$pdf->SetFont('Arial', 'B', 12);
$pdf->MultiCell(100, 10, "JOB CARD : " . $jobcard['jc_number'], "B", "L");
$pdf->MultiCell(100, 10, "PROJECT : " . $jobcard['project_name'], "B", "L");
$pdf->MultiCell(100, 10, "MANAGER : " . $call->get_username($jobcard['account_manager_id']), "B", "L");
$pdf->MultiCell(100, 5, "", "", "L");

$orders_res = $db->query("orders", "SELECT * FROM orders WHERE jc_number = '{$jobcard['jc_number']}'");

$over_all_total = 0.00;
while ($order = $orders_res->fetch_assoc()) {
    $pdf->Cell(30, 5, "", "", 1, 'L');

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(30, 8, "P.O.", "B", 0, 'L');
    $pdf->Cell(30, 8, "DATE", "B", 0, 'L');
    $pdf->Cell(30, 8, "STATUS", "B", 0, 'L');
    $pdf->Cell(30, 8, "FOR", "B", 0, 'L');
    $pdf->Cell(30, 8, "BY", "B", 0, 'L');
    $pdf->Cell(30, 8, "REFERENCE", "B", 1, 'L');
    $pdf->SetFont('Arial', '', 8);
    $order_total = 0.00;
    $pdf->Cell(30, 8, $order['po_number'], "B", 0, 'L');
    $pdf->Cell(30, 8, $order['date_time_created'], "B", 0, 'L');
    $pdf->Cell(30, 8, $order['status'], "B", 0, 'L');
    $pdf->Cell(30, 8, $call->get_username($order['user_id']), "B", 0, 'L');
    $pdf->Cell(30, 8, $call->get_username($order['user_created']), "B", 0, 'L');
    $pdf->Cell(30, 8, $order['reference'], "B", 1, 'L');

    $order_items_res = $db->query("order_items", "SELECT * FROM order_items WHERE order_id = {$order['record_id']}");
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(180, 8, "ITEMS", "", 1, 'L');
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(50, 8, "NAME", "B", 0, 'L');
    $pdf->Cell(30, 8, "QUANTITY", "B", 0, 'L');
    $pdf->Cell(30, 8, "PRICE EACH (ex)", "B", 0, 'L');
    $pdf->Cell(30, 8, "STOCK TYPE", "B", 0, 'L');
    $pdf->Cell(30, 8, "RECEIVED", "B", 1, 'L');
    $pdf->SetFont('Arial', '', 8);

    while ($order_item = $order_items_res->fetch_assoc()) {
        $pdf->Cell(50, 8, $order_item['name'], "B", 0, 'L');
        $pdf->Cell(30, 8, $order_item['quantity'], "B", 0, 'L');
        $pdf->Cell(30, 8, "R " . number_format($order_item['purchase_price_ex'], 3), "B", 0, 'L');
        $order_total += $order_item['quantity'] * $order_item['purchase_price_ex'];
        if ($order_item['stock_type'] == 0) {
            $pdf->Cell(30, 8, "STOCK", "B", 0, 'L');
        }
        if ($order_item['stock_type'] == 1) {
            $pdf->Cell(30, 8, "NON STOCK", "B", 0, 'L');
        }
        if ($order_item['stock_type'] == 2) {
            $pdf->Cell(30, 8, "UNITS", "B", 0, 'L');
        }
        $order_trans_res = $db->query("order_trans", "SELECT SUM(amount) as total FROM order_trans WHERE order_id = {$order['record_id']} AND stock_id = {$order_item['stock_id']} AND amount > 0");
        $order_trans = $order_trans_res->fetch_assoc();
        $pdf->Cell(30, 8, $order_trans['total'], "B", 1, 'L');
    }
    $pdf->Cell(180, 12, "ORDER TOTAL: R " . number_format($order_total, 3), "B", 1, 'L');
    $over_all_total += $order_total;

}
$pdf->Cell(180, 12, "", "", 1, 'L');
$pdf->Cell(180, 12, "JOB CARD TOTAL: R " . number_format($over_all_total, 3), "B", 1, 'L');
// dispatched
$pdf->SetFont('Arial', 'B', 10);

$order_trans_res = $db->query("order_trans", "SELECT * FROM order_trans WHERE job_card_no = '{$jobcard['jc_number']}' AND amount < 0 ORDER BY record_id DESC");
$pdf->Cell(180, 12, "DISPATCHED:", "", 1, 'L');
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(100, 8, "NAME", "B", 0, 'L');
$pdf->Cell(30, 8, "AMOUNT", "B", 0, 'L');
$pdf->Cell(30, 8, "DATE TIME", "B", 0, 'L');
$pdf->Cell(30, 8, "USER", "B", 1, 'L');
$pdf->SetFont('Arial', '', 8);
while ($order_trans = $order_trans_res->fetch_assoc()) {
    $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = {$order_trans['stock_id']}");
    $stock = $stock_res->fetch_assoc();
    $stock_desctioption = $stock['description'];
    $date_time = $order_trans['date_time'];
    $user = $call->get_username($order_trans['user_id']);
    $amount = $order_trans['amount'];
    $pdf->Cell(100, 8, $stock_desctioption, "B", 0, 'L');
    $pdf->Cell(30, 8, $amount, "B", 0, 'L');
    $pdf->Cell(30, 8, $date_time, "B", 0, 'L');
    $pdf->Cell(30, 8, $user, "B", 1, 'L');

}

$pdf->Cell(180, 12, "", "", 1, 'L');

$pdf->SetFont('Arial', 'B', 10);

$order_trans_res = $db->query("order_trans", "SELECT * FROM order_trans WHERE job_card_no = '{$jobcard['jc_number']}' AND amount > 0 ORDER BY record_id DESC");
$pdf->Cell(180, 12, "RETURNS:", "", 1, 'L');
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(100, 8, "NAME", "B", 0, 'L');
$pdf->Cell(30, 8, "AMOUNT", "B", 0, 'L');
$pdf->Cell(30, 8, "DATE TIME", "B", 0, 'L');
$pdf->Cell(30, 8, "USER", "B", 1, 'L');
$pdf->SetFont('Arial', '', 8);
while ($order_trans = $order_trans_res->fetch_assoc()) {
    $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = {$order_trans['stock_id']}");
    $stock = $stock_res->fetch_assoc();
    $stock_desctioption = $stock['description'];
    $date_time = $order_trans['date_time'];
    $user = $call->get_username($order_trans['user_id']);
    $amount = $order_trans['amount'];
    $pdf->Cell(100, 8, $stock_desctioption, "B", 0, 'L');
    $pdf->Cell(30, 8, $amount, "B", 0, 'L');
    $pdf->Cell(30, 8, $date_time, "B", 0, 'L');
    $pdf->Cell(30, 8, $user, "B", 1, 'L');

}

$pdf->Cell(180, 12, "", "", 1, 'L');
$pdf->SetFont('Arial', 'B', 10);

$order_trans_res = $db->query("order_trans", "SELECT DISTINCT stock_id,user_id FROM order_trans WHERE job_card_no = '{$jobcard['jc_number']}' ORDER BY record_id DESC");
$pdf->Cell(180, 12, "NETT:", "", 1, 'L');
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(100, 8, "NAME", "B", 0, 'L');
$pdf->Cell(30, 8, "AMOUNT", "B", 0, 'L');
$pdf->Cell(30, 8, "DATE TIME", "B", 0, 'L');
$pdf->Cell(30, 8, "USER", "B", 1, 'L');
$pdf->SetFont('Arial', '', 8);
while ($order_trans = $order_trans_res->fetch_assoc()) {
    $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = {$order_trans['stock_id']}");
    $stock = $stock_res->fetch_assoc();
    $stock_desctioption = $stock['description'];
    $date_time = $order_trans['date_time'];
    $user = $call->get_username($order_trans['user_id']);
    // get amount from each stock
    $amount_res = $db->query("order_trans", "SELECT SUM(amount) AS total FROM order_trans WHERE stock_id = {$order_trans['stock_id']} AND job_card_no = '{$jobcard['jc_number']}'");
    $amount = $amount_res->fetch_assoc();
    $amount = $anmount['total'];
    $pdf->Cell(100, 8, $stock_desctioption, "B", 0, 'L');
    $pdf->Cell(30, 8, $amount, "B", 0, 'L');
    $pdf->Cell(30, 8, $date_time, "B", 0, 'L');
    $pdf->Cell(30, 8, $user, "B", 1, 'L');

}

$pdf->Cell(180, 12, "", "", 1, 'L');





$pdf->Output("I");